
  
  
(defmeth scatterplot-proto :clear-curves ()
  (send self :redraw-curves))

(defmeth scatterplot-proto :redraw-curves ()
  (send self :start-buffering)
  (send self :clear-lines)
  (send self :redraw)
  (when (send self :add-linear)  
        (apply #'send self :add-principal-component (send self :pca-args)))
  (when (send self :add-kernel-line) 
        (apply #'send self :add-kernel-smooth (send self :ks-args)))
  (when (send self :add-lowess)  
        (apply #'send self :add-lowess-line (send self :low-args)))
  (when (send self :add-normal)  
        (apply #'send self :add-normal-contours (send self :norm-args)))
  (when (send self :add-quantile)
        (apply #'send self :add-quantours (send self :quan-args)))
  (when (send self :add-residual)
        (apply #'send self :add-residuals (send self :res-args)))
 ; (when (send self :add-regline?) 
 ;       (send self :draw-color 'red)
 ;       (send self :add-regline)
 ;       (send self :draw-color 'black))
  (when (send self :add-regline?) (send self :add-regline))
  (when (send self :add-regmeanline?) (send self :add-regmeanline))
  (when (send self :add-regresiduals?) (send self :add-regresiduals))
  (when (send self :add-regcontour?) (send self :add-regcontour))
  (when (send self :add-lsmt?) (send self :add-lsmt))

  (when (send self :add-regcolorlines?) (send self :add-regression-color-lines)) 
  (when (send self :add-lowcolorlines?) (send self :add-lowess-color-lines));PV
  (send self :draw-legends)
  (send self :redraw)
  (send self :buffer-to-screen)
  )


(defmeth scatterplot-proto :regvalues (&key renew )
  (cond
    ((and (not renew) (send self :regvalues-list)))
    (t
     (let* ((npts (send self :num-points))
            (x (send self :point-coordinate 0 (iseq npts)))
            (y (send self :point-coordinate 1 (iseq npts)))
            (mean-x (mean x))
            (mean-y (mean y))
            (std-x (standard-deviation x))
            (std-y (standard-deviation y))
            (r (correlation x y))
            (b (* r (/ std-y std-x)))
            (a (- mean-y (* b mean-x)))
            (yhat (+ a (* b x)))
            )
       (send self :legend3L (format nil "R =~5,2f" (fuzz r)))
       (send self :regvalues-list 
             (list npts x y yhat mean-x mean-y std-x std-y a b r))))))
  ;                  0  1 2  4     4      5      6     7   8 9 10

(defmeth scatterplot-proto :regcolors (&optional reg-attribute color)
  (cond ((and (not reg-attribute) (not color)) 
         (send self :regcolors-list))
    (t
     (let ((regcolors (send self :regcolors-list))
           (i (case reg-attribute ('regmeanline 0) ('regline 1) 
                ('regresiduals 2) ('regcontour 3) ('lsmt 4))))
       (when i
             (when color (setf (select regcolors i) color)
                   (send self :regcolor-list regcolors))
             (select regcolors i))))))

(defmeth scatterplot-proto :switch-add-reglines ()
  (send self :switch-add-regline)
  (send self :switch-add-regmeanline))

(defmeth scatterplot-proto :add-reglines ()
  (send self :add-regline)
  (send self :add-regmeanline))

(defmeth scatterplot-proto :switch-add-regline ()
  (send self :add-regline? (not (send self :add-regline?)))
  (cond 
    ((send self :add-regline?) (send self :add-regline))
    (t
     (when (send self :add-regresiduals?)
           (send self :switch-add-regresiduals))
     (send self :clear-curves)))
  (send self :add-regline?))

(defmeth scatterplot-proto :add-regline ()
  (let* ((now (send self :regcolors 'regline)))
    (send self :abline 
          (select (send self :regvalues) 8)
          (select (send self :regvalues) 9)
          :color now)
    now))

(defmeth scatterplot-proto :switch-add-regmeanline ()
  (send self :add-regmeanline? (not (send self :add-regmeanline?)))
    (if (send self :add-regmeanline?)
        (send self :add-regmeanline)
        (send self :clear-curves))
  (send self :add-regmeanline?))

(defmeth scatterplot-proto :add-regmeanline ()
  (let ((b4 (send self :draw-color))
        (now (send self :regcolors 'regmeanline))
        )
    (send self :draw-color now)
    (send self :abline  (select (send self :regvalues) 5) 0 :color now)
    (send self :draw-color b4)
    now))

(defmeth scatterplot-proto :switch-add-lsmt ()
  (send self :add-lsmt? (not (send self :add-lsmt?)))
  (if (send self :add-lsmt?)
      (send self :add-lsmt)
      (send self :clear-curves))
  (send self :add-lsmt?))

(defmeth scatterplot-proto :add-lsmt ( &optional x y &key (color nil))
  (let* ((now (send self :regcolors 'lsmt))
         (n (send self :num-points))
         (curvar (send self :current-variables))
         (x-values (if x x (send self :point-coordinate (first curvar) (iseq n))))
         (y-values (if y y (send self :point-coordinate (second curvar) (iseq n))))
         (r (correlation x-values y-values))
         (x-ranks (order x-values))
         (x-ordered (select x-values x-ranks))
         (y-permuted (if (< r 0)
                         (reverse (select y-values x-ranks))
                         (select y-values x-ranks)))
         (y-trans (lsmt x-ordered y-permuted)))
    (send self :add-lines 
          (send self :make-high-d-lines 
                (if (< r 0) (reverse x-ordered)
                   x-ordered)
                y-trans)
          :color now)
    now))

(defmeth scatterplot-proto :switch-add-regresiduals 
  (&key (contour-values (list 1 2 3)) (axes t) reg)
  (send self :add-regresiduals? (not (send self :add-regresiduals?)))
  (cond 
    ((send self :add-regresiduals?)
     (send self :add-regresiduals)
     (unless (send self :add-regline?)
             (send self :switch-add-regline)))
    (t
     (send self :clear-curves)))
  (send self :add-regresiduals?))

(defmeth scatterplot-proto :add-regresiduals ()
  (let* ((rv (send self :regvalues))
         (n (select rv 0))
         (x (select rv 1))
         (y (select rv 2))
         (yhat (select rv 3))
         )
    (when (send self :showing)
          (dotimes (i n)
                   (send self :add-lines
                         (list (select x i) (select x i))
                         (list (select yhat i) (select y i))
                         :draw nil
                         :color (send self :point-color i)))
          (send self :redraw)
          )))


(defmeth scatterplot-proto :switch-add-regcontour (&key (color 'orange))
  (send self :add-regcontour? (not (send self :add-regcontour?)))
    (if (send self :add-regcontour?)
        (send self :add-regcontour)
        (send self :clear-curves))
  (send self :add-regcontour?))


(defmeth scatterplot-proto :add-regcontour ()
  (send self :add-normal-contours  :contour-values (list 1.96 2.58) :reg t :axes nil 
        :color (send self :regcolors 'regcontour))
  (send self :regcolors 'regcontour))


;(defmeth scatterplot-proto :add-regcontour ()
 ; (send self :add-normal-contours  :contour-values (list 1.96 2.58) :reg t :axes nil))

(defmeth scatterplot-proto :make-high-d-lines (x y)
  (let* ((nvar (send self :num-variables))
         (cur-var (send self :current-variables))
         (zeros) (xy))
    (when (> nvar 2)
          (setf zeros (repeat 0 (length x))))
    (dotimes (i nvar)
             (cond
               ((= i (first cur-var))
                (setf xy (add-element-to-list xy x)))
               ((= i (second cur-var))
                (setf xy (add-element-to-list xy y)))
               (t
                (setf xy (add-element-to-list xy zeros)))))
    xy))

#|
(defmeth scatterplot-proto :add-reglines 
  (&key (regression t) (mean t) (correlation t)
        (residuals nil) (contours nil) (contour-values (list 1.5)))
  "Args: (REGRESSION T) (MEAN T) (CORRELATION T) (RESIDUALS NIL) 
(CONTOURS NIL) (CONTOUR-VALUES (LIST 1.5))
Adds REGRESSION line, MEAN line, CORRELATION value, RESIDUALS lines, and normal CONTOURS at CONTOUR-VALUES [(list 1.5)] to plot, using information based solely on the point coordinates of the first two content variables of this plot. NOTE: CONTOURS only work right when slope is 1."
  (send self :reg-args 
        `(:regression ,regression :mean ,mean :correlation ,correlation
          :residuals ,residuals :contours ,contours :contour-values ,contour-values))
  (let* ((npts (send self :num-points))
         (x (send self :point-coordinate 0 (iseq npts)))
         (y (send self :point-coordinate 1 (iseq npts)))
         (mean-y (mean y))
         (std-x (standard-deviation x))
         (std-y (standard-deviation y))
         (r (correlation x y))
         (b (* r (/ std-y std-x)))
         (a (- mean-y (* b (mean x))))
         (yhat (+ a (* b x)))
         )
    (when (send self :showing)
          (send self :draw-color 'red)
          (when regression (send self :abline a b))
          (when mean (send self :abline mean-y 0))
          (send self :draw-color 'dark-red)
          (when contours
                (send self :add-normal-contours 
                      :contour-values (list 1.5) :reg t :axes nil :slope b
                      ))
          (when residuals 
                (dotimes (i (length y))
                         (send self :add-lines
                               (list (select x i) (select x i))
                               (list (select yhat i) (select y i))
                               :draw nil
                               :color (send self :point-color i))))
          (when correlation (send self :legend3L (format nil "R =~5,2f" (fuzz r))))
          )
    ))


(defmeth scatterplot-proto :add-residuals (&key (color 'blue) (width 1) (type 'reg))
  (send self :res-args `(:color ,color :width ,width :type ,type))
  (let* ((cur-var (send self :current-variables))
         (npts (send self :num-points))
         (varx (send self :point-coordinate (first cur-var) (iseq npts)))
         (vary (send self :point-coordinate (second cur-var) (iseq npts)))
         )
   (send self :add-residual-lines varx vary 
         :color color :width width :type type)))
 
(defmeth scatterplot-proto :add-residual-lines 
  (x y &key (color 'blue) (width 1) (type 'reg))
  (dotimes (i (length x))
           (send self :add-lines (list (select x i) 
                                       (if (equal type 'reg) (select x i) (select y i)))
                                 (list (select x i) (select y i))
                 :color color :width width)))
|#

(defmeth scatterplot-proto :add-principal-component (&key (width 1) (color 'blue))
"Args: (WIDTH 1) (COLOR 'BLUE)
Adds first principal component line to plot."
  (send self :pca-args `(:color ,color :width ,width))
  (let* ((cur-var (send self :current-variables))
         (npts (send self :num-points))
         (varx (send self :point-coordinate (first cur-var) (iseq npts)))
         (vary (send self :point-coordinate (second cur-var) (iseq npts)))
         (meanx (mean varx))
         (meany (mean vary))
         (xymat (bind-columns (- varx meanx) (- vary meany)))
         (prod (covariance-matrix xymat))
         (eigsolution (eigen prod))
         (eigval (sqrt (first eigsolution)))
         (eigvec (second eigsolution))
         (dist+ (sqrt (+ (^ (- meanx (max varx)) 2) (^ (- meany (max vary)) 2))))
         (dist- (sqrt (+ (^ (- meanx (min varx)) 2) (^ (- meany (min vary)) 2))))
         (dist (max dist+ dist-))
         (x (list (- meanx (* dist  (select (first eigvec) 0)))
                  (+ meanx (* dist  (select (first eigvec) 0)))))
         (y (list (- meany (* dist  (select (first eigvec) 1)))
                  (+ meany (* dist  (select (first eigvec) 1)))))
         (xy (send self :make-high-d-lines x y))
         (overlay (first (send self :slot-value 'overlays)))
         (color-on? nil)
         (ratio (/ (ssq (- varx meanx)) (ssq (- vary meany))))
         ) 
    (if overlay
        (setf color-on? (and (send overlay :color-mode) (> *color-mode* 0)))
        (setf color-on? (> *color-mode* 0))) 
    (send self :add-lines xy :color (if color-on? color 'black) :width width)
    ))

(defmeth scatterplot-proto :add-lowess-line 
  (&key (color 'red) (width 1))
"Keyword Args: (COLOR 'RED) (WIDTH 1)
Adds Lowess function to plot. The slot LOWESS-FRACTION must be spefified prior to useing this method."
  (send self :low-args `(:color ,color :width ,width))
  (let* ((cur-var (send self :current-variables))
         (npts (send self :num-points))
         (varx (send self :point-coordinate (first cur-var) (iseq npts)))
         (vary (send self :point-coordinate (second cur-var) (iseq npts)))
         (lxy (lowess varx vary :f (send self :lowess-fraction)))
         (xy (send self :make-high-d-lines (first lxy) (second lxy)))
         (overlay (first (send self :slot-value 'overlays)))
         (color-on? nil)
         )
    (if overlay
        (setf color-on? (and (send overlay :color-mode) (> *color-mode* 0)))
        (setf color-on? (> *color-mode* 0)))
    (send self :add-lines xy
          :color (if color-on? color 'black) :width width)))

(defmeth scatterplot-proto :add-kernel-smooth (&key (color 'green) (width 1) (type 0))
"Keyword Args: (COLOR 'magenta) (WIDTH 1) (TYPE 0)
Adds Kernel smoother of type TYPE to plot. Type can be 0 through 3 for Bisquare, Gaussian, Triangular and Uniform, respectively" 
  (send self :ks-args `(:color ,color :width ,width :type ,type))
  (let* ((type (case (send self :kernel-line-type) (0 'b) (1 'g) (2 't) (3 'u)))
         (kernel-width (send self :kernel-width-value))
         (cur-var (send self :current-variables))
         (npts (send self :num-points))
         (varx (send self :point-coordinate (first cur-var) (iseq npts)))
         (vary (send self :point-coordinate (second cur-var) (iseq npts)))
         (kxy (kernel-smooth varx vary :type type :width (send self :kernel-width-value)))
         (xy (send self :make-high-d-lines (first kxy) (second kxy)))
         (overlay (first (send self :slot-value 'overlays)))
         (color-on? nil))
    (setf type (case (send self :kernel-line-type) (0 'b) (1 'g) (2 't) (3 'u)))
    (if overlay
        (setf color-on? (and (send overlay :color-mode) (> *color-mode* 0)))
        (setf color-on? (> *color-mode* 0)))
    (send self :add-lines xy 
          :color (if color-on? color 'black) :width width)))


(defmeth scatterplot-proto :add-normal-contours 
  (&key (contour-values (list 1 2 3)) (reg nil) (slope 1)
        (num-interp 16) (spokes nil) (axes t)
        (draw t) (color 'black) (width 1))
"Keyword Args: (contour-values (list 1 2 3)) (reg nil) (num-interp 16) (spokes nil) (axes t) (draw t) (color 'black) (width 1))
Adds normal contour-values (standard-deviation-based contours) to scatterplots. Contours are located at standard-deviation values specified by CONTOUR-VALUES, and are interpolated NUM-INTERP times for each quandrant. Contours are principal axes, unless REG is T, in which case are regres axes if plot is a regression plot (only appropriate for regression plots). When SPOKES is T, lines are drawn, for each interpolant, from the center to the contour. When AXES is T, the horizontal and vertical interpolant lines are drawn. All lines have color COLOR and width WIDTH."
  (send self :norm-args `(:color ,color :width ,width :contour-values ,contour-values
                          :reg ,reg :num-interp ,num-interp :spokes ,spokes 
                          :axes ,axes :draw ,draw))
  (cond
    ((send self :norm-contour-xy)
     (send self :draw-contours (send self :norm-contour-xy)
           :contours (first (send self :norm-contour-values) )
           :num-interp num-interp :spokes spokes 
           :axes (second (send self :norm-contour-values))
           :draw draw :color color :width width)
     )
    (t
     (let* ((npts (send self :num-points))
            (x (send self :point-coordinate 
                     (select (send self :current-variables) 0) (iseq npts)))
            (y (send self :point-coordinate 
                     (select (send self :current-variables) 1) (iseq npts)))
            (xmean (mean x))
            (ymean (mean y))
            (xymat (bind-columns (- x xmean) (- y ymean)))
            (covxy (covariance-matrix xymat))
            (eigsolution (eigen covxy))
            (sqrteigs (sqrt (first eigsolution)))
            (eigvecmat (matrix '(2 2) 
                     (if reg (list 1 1 -1 1) (combine (second eigsolution)))))
            (scores (%* xymat eigvecmat))
            (coefsmat (matrix '(2 2)
                     (if reg (list 1 slope (- slope) 1) (combine (second eigsolution)))))
            (contour-xy)
            )
       (setf contour-xy
             (send self :calculate-contours scores num-interp contour-values 
                   xmean ymean (select sqrteigs 0) (select sqrteigs 1) axes spokes
                   color width draw :coefs coefsmat))
       (send self :norm-contour-xy contour-xy)
       (send self :draw-contours contour-xy
             :contours contour-values :num-interp num-interp :spokes spokes :axes axes
             :draw draw :color color :width width)
       (send self :norm-contour-values (list contour-values axes reg))
       ))))

  
#|Wont Compile. Blows Compiler.
(defmeth scatterplot-proto :add-quantours 
  (&key (contour-values (list .75 .90 .95 .975 1.00))
        (num-interp 16) (spokes nil) (axes t)
        (draw t) (color 'red) (width 1))
"Keyword Args:  (contour-values (list .75 .90 .95 .975 1.00)) (num-interp 16) (spokes nil) (axes t) (draw t) (color 'red) (width 1))
Adds quantours (quantile-based contours) to scatterplots. Quantours are located at quantile-levels specified by CONTOUR-VALUES, and are interpolated NUM-INTERP times for each quandrant. When SPOKES is T, lines are drawn, for each interpolant, from the center to the contour. When AXES is T, the horizontal and vertical interpolant lines are drawn. All lines have color COLOR and width WIDTH."
  (send self :norm-args `(:color ,color :width ,width :contour-values ,contour-values
                          :num-interp ,num-interp :spokes ,spokes :axes ,axes :draw ,draw))
  (let ((contours (if (> (send self :quantour-value) 1)
                          contour-values
                          (list (send self :quantour-value)))))
    (cond
      (
       (send self :quantour-xy)
       (send self :draw-contours (send self :quantour-xy)
             :contours contours :num-interp num-interp :spokes spokes :axes axes
             :draw draw :color color :width width))
      (t
       (let* ((nspokes (1+ (* 4 num-interp)))
              (ncontours (length contours))
              (overlay (first (send self :slot-value 'overlays)))
              (npts (send self :num-points))
              (x (send self :point-coordinate 
                       (select (send self :current-variables) 0) (iseq npts)))
              (y (send self :point-coordinate 
                       (select (send self :current-variables) 1) (iseq npts)))
              (xmean (mean x))
              (ymean (mean y))
              (xstdv (standard-deviation x))
              (ystdv (standard-deviation y))
              (xn (/ (- x xmean) xstdv))
              (yn (/ (- y ymean) ystdv))
              (xymat (bind-columns xn yn))
              (sin (sin (rseq pi (- pi) nspokes)))
              (cos (cos (rseq pi (- pi) nspokes)))
              (coef-mat (bind-columns sin cos))
              (L-list) (coefx) (coefy)
              (project) (xscale) (yscale)
              (L 0) (quantiles nil) (b)
              (xy) (2dxy) (xy-list)
              (x-list) (y-list) 
              (k 0) (color-on?) (draw-axes) (draw-spokes)
              )
         (send self :quantour-xy
               (send self :calculate-contours xymat num-interp contours 
                     xmean ymean xstdv ystdv axes spokes
                     color width draw :stat-type "quantiles"))
         (send self :draw-contours (send self :quantour-xy)
               :contours contours :num-interp num-interp :spokes spokes :axes axes
               :draw draw :color color :width width))
       ))))
|#
  
  (defmeth scatterplot-proto :calculate-contours 
  (xymat num-interp contours xmean ymean xstdv ystdv axes spokes color width draw
         &key coefs)
  (let* ((nspokes (1+ (* 4 num-interp)))
         (ncontours (length contours))
         (sin (sin (rseq pi (- pi) nspokes)))
         (cos (cos (rseq pi (- pi) nspokes)))
         (coef-mat (bind-columns sin cos))
         (L-list) (coefx) (coefy)
         (project) (xscale) (yscale)
         (L 0) (values nil) (b)
         (xy) (2dxy) (xy-list)
         (x-list) (y-list) 
         (k 0) (color-on?) (draw-axes) (draw-spokes)
         (overlay (first (send self :slot-value 'overlays)))
         (contour-xy)(maxdist 0)
         )
    (when overlay 
          (setf color-on? (and (send overlay :color-mode) 
                               (> *color-mode* 0))))
    (dotimes 
     (j ncontours)
     (setf x-list nil)
     (setf y-list nil)
     (dotimes
      (i nspokes)
      (when (= j 0)
            (setf coefx (select coef-mat i 0))
            (setf coefy (select coef-mat i 1))
            (when (not coefs)
                  (setf b (matrix '(2 1) (list coefx coefy)))
                  (setf project (matmult xymat b))
                  (setf values (mapcar #'(lambda (levels) 
                                           (quantile project levels)) contours)))
            (when coefs
                  (setf values contours)) 
            (setf L-list (add-element-to-list L-list values))
            )
      (if (and axes (= j (1- ncontours))(= 0 (rem i num-interp)))
          (setf draw-axes t) (setf draw-axes nil))
      (if (and spokes (= j (1- ncontours)))
          (setf draw-spokes t) (setf draw-spokes nil))
      (setf coefx (select coef-mat i 0))
      (setf coefy (select coef-mat i 1))
      (setf L (select (select L-list i) j))
      (setf xscale (/ coefx (sqrt (+ (^ coefx 2) (^ coefy 2)))))
      (setf yscale (/ coefy (sqrt (+ (^ coefx 2) (^ coefy 2)))))
      (setf direction-vector (vector (* xstdv (* L xscale))
                                     (* ystdv (* L yscale))))
      (when coefs
            (setf direction-vector (%* direction-vector coefs)))
      (setf 2dxy (list (list xmean (+ xmean (select direction-vector 0)))
                       (list ymean (+ ymean (select direction-vector 1)))))
      (setf xy (send self :make-high-d-lines (first 2dxy) (second 2dxy)))
      (when draw-spokes 
            (setf contour-xy (add-element-to-list contour-xy xy)))
      (when draw-axes
            (setf contour-xy (add-element-to-list contour-xy xy)))
      (setf x-list (add-element-to-list x-list (second (first 2dxy))))
      (setf y-list (add-element-to-list y-list (second (second 2dxy))))
    ;  (when (= i 0)
    ;        (setf dist (sqrt (+ (^ (- (first x-list) xmean) 2)
    ;                            (^ (- (first y-list) ymean) 2))))
    ;        (unless maxdist (setf maxdist dist))
    ;        (when (> dist maxdist) (setf maxdist dist)
    ;              (setf *i-best* i)
    ;              ))
      )
     (setf contour-xy (add-element-to-list contour-xy (list x-list y-list)))
     )
    contour-xy))


(defmeth scatterplot-proto :draw-contours 
  (xy &key (contours (list .75 .90 .95 .975 1.00))
      (num-interp 16) (spokes nil) (axes t)
      (draw t) (color 'red) (width 1))
  (let* ((nspokes (1+ (* 4 num-interp)))
         (ncontours (length contours))
         (x-list) (y-list) (k 0) (color-on?) (draw-axes) (draw-spokes)
         (overlay (first (send self :slot-value 'overlays)))
         )
    (cond 
      ((not xy) 
       (fatal-message "No Quantours to redraw")
       
       )
      (t
       (when overlay
             (setf color-on? (and (send overlay :color-mode) 
                                     (> *color-mode* 0))))
       (dotimes 
        (j ncontours) 
        (when (or spokes axes)
              (dotimes
               (i nspokes)
               (if (and axes (= j (1- ncontours))(= 0 (rem i num-interp)))
                   (setf draw-axes t) (setf draw-axes nil))
               (if (and spokes (= j (1- ncontours)))
                   (setf draw-spokes t) (setf draw-spokes nil))
               (when draw-spokes
                     (send self :add-lines (select xy k) :color 
                           (if color-on? color 'black) 
                           :width width :draw nil)
                     (setf k (1+ k)))
               (when draw-axes
                     (send self :add-lines (select xy k) :draw nil)
                     (setf k (1+ k))) ))
        (setf x-list (select (select xy k) 0))
        (setf y-list (select (select xy k) 1))
        (send self :add-lines (send self :make-high-d-lines x-list y-list)
              :color (if color-on? color 'black) :width width :draw nil)
        (setf k (1+ k)))
    (when draw (send self :redraw-content)
          (send self :draw-legends))))))


;Used in loglinear and regcat

(defmeth scatterplot-proto :my-new-plot (x &optional (y nil))
  (let*
    ((num-points (send self :num-points))
     (color (send self :point-color (iseq num-points)))
     (symbol (send self :point-symbol (iseq num-points)))
     (state (send self :point-state (iseq num-points)))
     (selection (send self :selection))
     (showing (send self :point-showing (iseq num-points)))
     (labels (send self :point-label (iseq num-points)))
     )
    (send self :start-buffering)
    (send self :clear-points)
    
    (if y (send self :add-points x y)
        (send self :add-points x))
    (send self :point-color (iseq num-points) color)
    (send self :point-symbol (iseq num-points) symbol)
    (send self :point-state (iseq num-points) state)
    (send self :selection selection)
    (send self :point-label (iseq num-points) labels)
    (send self :redraw)
    (send self :buffer-to-screen)
     ))